EvaluateScript("Colours.js");
EvaluateScript("Mouse Library.js");

var mouse = new _mouse();

var scrollUp = LoadImage("Scroll Up.png");
var scrollDown = LoadImage("Scroll Down.png");
var scrollLeft = LoadImage("Scroll Left.png");
var scrollRight = LoadImage("Scroll Right.png");
var background = LoadSurface("Background.png");
var tile32 = LoadImage("32 Tile.png");

//========================================================================================================================
//                                                     Draw Text
//========================================================================================================================
var font = LoadFont("Font.rfn");
function drawText(x, y, text, color)
{
  var color = color || white
  font.setColorMask(black);
  font.drawText(x + 1, y + 1, text);
  font.setColorMask(color);
  font.drawText(x, y, text);
}

//========================================================================================================================
//                                                     Get Super Parent
//========================================================================================================================
function getParent(obj)
{
  while (obj.parent)
  {
    obj = obj.parent;
  }
  return obj
}

//========================================================================================================================
//                                                     Create Window
//========================================================================================================================

function createWindow(w, h, fill)
{
  var window = CreateSurface(w + 4, h + 4, CreateColor(0, 0, 0, 0));

  if (fill)
  {
    var testX = (window.width - 4) / background.width;
    var testY = (window.height - 4) / background.height;
  
    for (var x = 0; x < testX; x++)
    {
      for (var y = 0; y < testY; y++)
      {
        window.blitSurface(background, 2 + (x * background.width), 2 + (y * background.height));
      }
    }
  }
  
  window.line(w + 3, 0, w + 3, h + 3, black);
  window.line(0, h + 3, w + 3, h + 3, black);
  
  window.line(1, 1, w + 2, 1, white);
  window.line(1, 1, 1, h + 1, white);
  
  window.line(1, h + 2, w + 2, h + 2, windowGrey2);
  window.line(w + 2, 2, w + 2, h + 2, windowGrey2);
  
  window.line(0, 0, w + 2, 0, windowGrey1);
  window.line(0, 0, 0, h + 2, windowGrey1);
  
  return window.createImage();
}

// NOTE: For multi support save both the image and surface
//========================================================================================================================
//                                                     Tile Object
//========================================================================================================================
function tileObject(image, id, column, row) // A induvidual tile object
{
  this.surface = image; // Stores a surface copy of the tile
  this.image = image.createImage(); // Stores a image copy of the tile
  this.id = id; // Stores the ID for the tile in a 1 dimensional respect
  this.column = column; // Stores the tiles reference via its column in a multidimensional array
  this.row = row; // Stores the tiles reference via its row in a multidimensional array
  
  this.blit = function(x, y) // Added a blit function to avoid bloated commands
  {
    this.image.blit(x, y); // A simple call to the original blit command
  }
}
// NOTE: We couldnt support multiple tilesizes while allowing access to all tilesets. The only potential way would be to limit the list of available
// Tilesets to only those with a tileset matching the specified. EG if you specify 32x32 for a map then only the tilesets of those size would be available
// Either way the tilesizes would have to be stored in the induvidual map for reference and in the tileset to compare

//========================================================================================================================
//                                                     Tileset Object
//========================================================================================================================
function tilesetObject(name) // A tileset Object
{
  this.name = name; // Stores the name of the tileset image
  this.surface = LoadImage("~/Tilesets/" + name).createSurface(); // Stores a surface copy of the tilesets image
  this.tileHeight = 32; // This would need to be found somehow
  this.tileWidth = 32; // This would need to be found somehow
  this.image = LoadImage("~/Tilesets/" + name); // Stores a image copy of the tilesets image
  this.width = this.image.width / this.tileWidth; // Stores the amount of tiles via width of the image
  this.height = this.image.height / this.tileHeight; // Stores the amount of tiles via height of the image
  this.numTiles = this.height * this.width; // Gets the overall number of tiles
  this.tile = []; // Array containing the induviadual tiles broken down from the original image
  for (var y = 0; y < this.height; y++)
  {
    for (var x = 0; x < this.width; x++)
    {
      // Creates a new TILEOBJECT of the tile
      this.tile[this.tile.length] = new tileObject(this.surface.cloneSection(x * 32, y * 32, 32, 32), this.tile.length, x, y);
    }
  }
}

// NOTE: Two ways to detect passibility strike me, either create a huge image of the map in black and white to detect collision or induvidually
// Store passibility in each tile. The latter would be slower due to induvidual checks, Okay for tilebased movement I suppose as the checks will only be
// done before moving, pixel movement would require lots of checks

function mapObject(map)
{
  this.map = OpenFile("~/Maps" + map);
  this.height = this.map.read("height", 50);
  this.width = this.map.read("width", 50);
  this.layers = 2; //this.map.read("layers", 2);
  this.tileset = this.map.read("tileset", 0);
  this.tiles = [];
  for (var l = 0; l < this.layers; l++)
  {
    this.tiles[l] = [];
    for (var y = 0; y < this.height; y++)
    {
      this.tiles[l][y] = [];
      for (var x = 0; x < this.width; x++)
      {
        this.tiles[l][y][x] = 1;//this.map.read("tiles[" + l + "][" + y + "][" + x + "]", 1);
        if (y == 49) this.tiles[l][y][x] = 4
        if (x == 49) this.tiles[l][y][x] = 4
      }
    }
  }
}

var map = new mapObject("Test.nmp");

var tileset = []; // Keep tilesets in the global scope so all panels could reference it if required

var files = GetFileList("~/Tilesets"); // Get list of files in the tilesets folder
//var i = "";
//i += files;
//Abort()
for (var i = 0; i < files.length; i++)
{
  tileset[tileset.length] = new tilesetObject(files[i]); // Create new tileset object and store for each tileset
}

files = undefined; // Probably not neccesary but but what the hell 


//========================================================================================================================
//                                                     Drop Box
//========================================================================================================================
function dropBox(parent, fileList)
{
  this.name = "Drop Box";
  this.open = false;
  this.parent = parent;
  this.x = this.parent.x;
  this.y = this.parent.y + 2 + 24;
  this.h = this.parent.h - 26;
  this.w = this.parent.w;
  this.fileList = fileList;
  this.currentSelection = 0;
  
  this.vScroll = 0; // Set current posision on scroll vertical
  this.hScroll = 0; // Set current position on scroll horizontal
  this.hInt = 16; // Set width of columns - default to 1
  this.vInt = 16; // Set height of rows - default to 1
  this.vMax = ((tileset.length * 16) - this.h - 26) / this.vInt; // Subtracting the current page get remainder for scrolling purposes
  //this.hMax = (tileset[tilesetSelection].image.width - this.w) / this.hInt; // Subtracting the current page get remainder for scrolling purposes
  
  this.scrollBar = new verticalScrollBar(this); // Create scrollbar
  
  this.window = createWindow (this.parent.w, this.parent.h - 26, true);
  this.image = createWindow(parent.w - 4, 20).createSurface();

  this.image.line(2, 2, this.image.width - 4, 2, CreateColor(128, 128, 128, 255));
  this.image.line(2, 2, 2, this.image.height - 4, CreateColor(128, 128, 128, 255));

  this.image.line(2, this.image.height - 3, this.image.width - 3, this.image.height - 3, CreateColor(255, 255, 255, 255));
  this.image.line(this.image.width - 3, 2, this.image.width - 3, this.image.height - 3, CreateColor(255, 255, 255, 255));

  this.image.line(3, 3, this.image.width - 5, 3, CreateColor(0, 0, 0, 255));
  this.image.line(3, 3, 3, this.image.height - 5, CreateColor(0, 0, 0, 255));

  this.image.line(3, this.image.height - 4, this.image.width - 4, this.image.height - 4, CreateColor(192, 192, 192, 255));
  this.image.line(this.image.width - 4, 3, this.image.width - 4, this.image.height - 4, CreateColor(192, 192, 192, 255));

  this.image.createImage();
  
  this.scrollDown = new _button(this, this.w - 18, -20, scrollDown);
  this.scrollDown.name = "Scroll Down";
  this.scrollDown.leftOnPress = function()
  {
    this.parent.open = !this.parent.open;
  }
}

dropBox.prototype.handleMouse = function()
{
  this.scrollDown.handleMouse();
  if (this.open && mouse.isMouseOver(this.x, this.y, this.parent.w, this.parent.h, this)) 
  {
    if (this.open) this.scrollBar.handleMouse();
  } 
}

dropBox.prototype.render = function()
{
  //if (this.open && mouse.focus != this && mouse.focus != this.scrollDown && mouse.focus != this.scrollBar) this.open = false;
  this.image.blit(this.parent.x + 2, this.parent.y + 2);
  this.scrollDown.render();
  drawText(this.parent.x + 12, this.parent.y + 12, this.fileList[this.currentSelection].name);
  if (this.open)
  {
    var index = Math.floor((GetMouseY() - this.y) / 16);
    this.window.blit(this.x - 2 + 2, this.y);
    
    for (var i = 0; i < this.fileList.length; i++)
    {
      if (this.currentSelection == i) drawText(this.parent.x + 12, this.parent.y + 32 + (16 * i), this.fileList[i].name, red);
      else drawText(this.parent.x + 12, this.parent.y + 32 + (16 * i), this.fileList[i].name);
    }
    if (index > -1 && index < 12 && index < this.fileList.length) Rectangle(this.x - 2, this.y + (index * 16), this.parent.w, 16, CreateColor(192, 192, 192, 120));
    this.scrollBar.render();
  }
}

//========================================================================================================================
//                                                     Map Panel
//========================================================================================================================
function _mapPanel()
{
  this.name = "MapPanel"; // Objects name (Not needed, just used in mouse object while testing)
  this.x = 214; // Set panels X
  this.y = 20; // Set panels Y
  this.w = 422; // Set panels W
  this.h = 456; // Set Panels H
  this.window = createWindow(this.w, this.h, true); // Create a window image
  this.container = new _mapContainer(this, 10, 60, 402, 386, 32, 32);
  this.dropBox = new dropBox(this, [{ name: "Layer 0"}, { name: "Layer 1"}]); // Create DropBox
  this.dropBox.leftOnPress = function()
  {
    var index = Math.floor((GetMouseY() - this.y) / 16);
    if (index > -1 && index < 12 && index < this.fileList.length) 
    {
      this.currentSelection = index;
      layerSelection = index; 
    }
  }
}
_mapPanel.prototype.handleMouse = function()
{
  if (mouse.isMouseOver(this.x, this.y, this.w, this.h, this)) this.dropBox.handleMouse();
  if (!this.dropBox.open && mouse.isMouseOver(this.container.x + 2, this.container.y + 2, this.container.w, this.container.h, this.container)) this.container.handleMouse();
}

_mapPanel.prototype.render = function()
{
  this.handleMouse();
  this.window.blit(this.x, this.y);
  this.container.render();
  this.dropBox.render();
}

function _mapContainer(parent, x, y, w, h, hInt, vInt)
{
  this.name = "Map Container";
  this.parent = parent;
  this.x = this.parent.x + x;
  this.y = this.parent.y + y;
  this.w = w;
  this.h = h;
  this.tileW = Math.floor((this.w - 16) / 32);
  this.tileH = Math.floor((this.h - 16) / 32);
  
  this.pageWidth = Math.floor((this.w - 16) / 32); // Get amount of tiles within width
  this.pageHeight = Math.floor((this.h - 16) / 32); // Get amount of tiles within height
  
  this.vScroll = 0; // Set current posision on scroll vertical
  this.hScroll = 0; // Set current position on scroll horizontal
  this.hInt = hInt || 1; // Set width of columns - default to 1
  this.vInt = vInt || 1; // Set height of rows - default to 1
  this.vMax = map.height - this.pageHeight; // Subtracting the current page get remainder for scrolling purposes
  this.hMax = map.width - this.pageWidth; // Subtracting the current page get remainder for scrolling purposes
  
  this.vScrollBar = new verticalScrollBar(this, true); // Create scrollbar
  this.hScrollBar = new horizontalScrollBar(this, true); // Create scrollbar
  this.wheelScrollUp = function() // Refer to scroll bar for wheel functions
  {
    if (this.vScrollBar && this.vScrollBar.wheelScrollUp) this.vScrollBar.wheelScrollUp(); // If scrollbar has a wheel function run that
  }
  this.wheelScrollDown = function() // Create scrollbar
  {
    if (this.vScrollBar && this.vScrollBar.wheelScrollDown) this.vScrollBar.wheelScrollDown(); // If scrollbar has a wheel function run that
  }
  
  this.window = createWindow(this.w, this.h);
  
}

_mapContainer.prototype.handleMouse = function()
{
  if (mouse.isMouseOver(this.x, this.y, this.w, this.h, this)) this.vScrollBar.handleMouse(); this.hScrollBar.handleMouse();
}

_mapContainer.prototype.leftOnPress = function()
{
  var mouseX = Math.floor((mouse.x - this.x - 2) / 32) + this.hScroll; // Get tile co-ords
  var mouseY = Math.floor((mouse.y - this.y - 2) / 32) + this.vScroll; // Get tile co-ords
  if (mouseY >= 0 && mouseX >= 0 && mouseY < map.height && mouseX < map.width) map.tiles[layerSelection][mouseY][mouseX] = tileSelection;
}

_mapContainer.prototype.leftOnHeld = function()
{
  var mouseX = Math.floor((mouse.x - this.x - 2) / 32) + this.hScroll; // Get tile co-ords
  var mouseY = Math.floor((mouse.y - this.y - 2) / 32) + this.vScroll; // Get tile co-ords
  if (mouseY >= 0 && mouseX >= 0 && mouseY < map.height && mouseX < map.width) map.tiles[layerSelection][mouseY][mouseX] = tileSelection;
}

_mapContainer.prototype.render = function()
{
  var mouseX = Math.floor((mouse.x - this.x - 2) / 32); // Get tile co-ords
  var mouseY = Math.floor((mouse.y - this.y - 2) / 32); // Get tile co-ords
  this.window.blit(this.x, this.y); 
  SetClippingRectangle(this.x + 2, this.y + 2, this.w, this.h);
  if (mouse.isMouseOver(this.x + 2, this.y + 2, this.w, this.h)) // If mouse is over container
  {
    var mouseX = Math.floor((mouse.x - this.x - 2) / 32); // Get tile co-ords
    var mouseY = Math.floor((mouse.y - this.y - 2) / 32); // Get tile co-ords
  } 
  for (var l = 0; l < map.layers; l++)
  {
    for (var y = 0; y < this.tileH; y++)
    {
      for (var x = 0; x < this.tileW; x++)
      {
        // Draw tiles
        if(map.tiles[l][y + this.vScroll][x + this.hScroll] != undefined) tileset[map.tileset].tile[map.tiles[l][y + this.vScroll][x + this.hScroll]].blit(this.x + 2 + (x * 32), this.y + 2 + (y * 32));
        if (x == mouseX && mouseY == y) tile32.blit(this.x + 2 + (x * 32), this.y + 2 + (y * 32));
      }
    }
  }
  this.hScrollBar.render();
  this.vScrollBar.render()
  SetClippingRectangle(0, 0, 640, 480);
  drawText(0, 0, map.tiles[0][0][0]);
}


//========================================================================================================================
//                                                     Tile Panel
//========================================================================================================================

var tilesetSelection = 0; // Store current tileset in the global scope
var tileSelection = 0; // Store selected tile in the global scope
var layerSelection = 0;

function _tilePanel()
{
  this.name = "TilePanel"; // Objects name (Not needed, just used in mouse object while testing)
  this.x = 0; // Set panels X
  this.y = 100; // Set panels Y
  this.w = 212; // Set panels W
  this.h = 220; // Set Panels H
  this.window = createWindow(this.w, this.h, true); // Create a window image
  this.dropBox = new dropBox(this, tileset); // Create DropBox - NOT IMPLEMENTED, VISUAL ONLY
  this.dropBox.leftOnPress = function()
  {
    var index = Math.floor((GetMouseY() - this.y) / 16);
    if (index > -1 && index < 12 && index < tileset.length) 
    {
      this.currentSelection = index;
      tilesetSelection = index;
    // Will need to reset the container here
      this.parent.container.newScroll(32, 32);  
    }
  }
  this.container = new tilesetContainer(this, 2, 26, 208, 192, 32, 32); // Create a container within the panal, will be storing in arrays later
}
//========================================================================================================================
//                                                     Tile Panel - Handle Mouse
//========================================================================================================================
_tilePanel.prototype.handleMouse = function()
{
  // WE WOULD CHECK THE OBJECTS INTERNAL OBJECTS BEFORE ITSELF
  if (mouse.isMouseOver(this.x, this.y, this.w, this.h, this)) this.dropBox.handleMouse();
  if (!this.dropBox.open && mouse.isMouseOver(this.container.x + 2, this.container.y + 2, this.container.w, this.container.h, this.container)) this.container.handleMouse();
}
//========================================================================================================================
//                                                     Tile Panel - Render
//========================================================================================================================
_tilePanel.prototype.render = function()
{
  //SetClippingRectangle(this.x, this.y, this.w + 4, this.h + 4) // Dont allow drawing outside of panel
  
  this.window.blit(this.x, this.y); // Draw window
  this.container.render(); // Draw container - In future will need top be array and loop
  this.dropBox.render(); // Draw drop box - NOT IMPLEMENTED, VISUAL ONLY
  this.handleMouse(); // Handle the mouse before drawing
  //Rectangle(this.x, this.y, this.w, this.h, CreateColor(255, 0, 0, 255));
  //SetClippingRectangle(0, 0, 640, 480); // Reset scope for drawing
  //drawText(this.x, this.y - 20, mouse.isMouseOver(this.x, this.y, this.w + 4, this.h + 4));
}

//========================================================================================================================
//                                                     Tileset Container
//========================================================================================================================
function tilesetContainer(parent, x, y, w, h, hInt, vInt)
{
  this.name = "Tileset Container"; // Objects name (Not needed, just used in mouse object while testing)
  this.parent = parent; // Get Objects Parent
  this.window = createWindow(w, h); // Create window
  this.x = this.parent.x + x; // Set containers X
  this.y = this.parent.y + y; // Set containers Y
  this.h = h; // Set containers H
  this.w = w; // Set containers W
  this.pageWidth = Math.floor(this.w / 32); // Get amount of tiles within width
  this.pageHeight = Math.floor(this.h / 32); // Get amount of tiles within height
  
  this.vScroll = 0; // Set current posision on scroll vertical
  this.hScroll = 0; // Set current position on scroll horizontal
  this.hInt = hInt || 1; // Set width of columns - default to 1
  this.vInt = vInt || 1; // Set height of rows - default to 1
  this.vMax = (tileset[tilesetSelection].image.height - h) / this.vInt; // Subtracting the current page get remainder for scrolling purposes
  this.hMax = (tileset[tilesetSelection].image.width - w) / this.hInt; // Subtracting the current page get remainder for scrolling purposes
  
  this.scrollBar = new verticalScrollBar(this); // Create scrollbar
  this.wheelScrollUp = function() // Refer to scroll bar for wheel functions
  {
    if (this.scrollBar && this.scrollBar.wheelScrollUp) this.scrollBar.wheelScrollUp(); // If scrollbar has a wheel function run that
  }
  this.wheelScrollDown = function() // Create scrollbar
  {
    if (this.scrollBar && this.scrollBar.wheelScrollDown) this.scrollBar.wheelScrollDown(); // If scrollbar has a wheel function run that
  }
}

tilesetContainer.prototype.newScroll = function(hInt, vInt)
{
  this.vScroll = 0; // Set current posision on scroll vertical
  this.hScroll = 0; // Set current position on scroll horizontal
  this.hInt = hInt; // Set width of columns - default to 1
  this.vInt = vInt; // Set height of rows - default to 1
  this.vMax = (tileset[tilesetSelection].image.height - this.h) / this.vInt; // Subtracting the current page get remainder for scrolling purposes
  if (this.vMax < 0) this.vMax = 0;
  this.hMax = (tileset[tilesetSelection].image.width - this.w) / this.hInt; // Subtracting the current page get remainder for scrolling purposes
  
  this.scrollBar = new verticalScrollBar(this); // Create scrollbar
}
//========================================================================================================================
//                                                     Tileset Container - Handle Mouse
//========================================================================================================================
tilesetContainer.prototype.handleMouse = function()
{
  if (!mouse.isMouseOver(this.x + 2, this.y + 2, this.w - 16, this.h, this)) this.scrollBar.handleMouse(); // If mouse is over containers scrollbar and the button is clicked handle the scrollbars mouse control
}
//========================================================================================================================
//                                                     Tileset Container - Left On Press
//========================================================================================================================
tilesetContainer.prototype.leftOnPress = function()
{
  var mouseX = Math.floor((mouse.x - this.x - 2) / 32); // Get tile co-ords
  var mouseY = Math.floor((mouse.y - this.y - 2) / 32); // Get tile co-ords
  tileSelection = (this.vScroll * 6) + mouseX + (mouseY * 6);
}

//========================================================================================================================
//                                                     Tileset Container - Render
//========================================================================================================================
tilesetContainer.prototype.render = function()
{
  this.window.blit(this.x, this.y); // Draw window
  if (mouse.isMouseOver(this.x + 2, this.y + 2, this.w, this.h)) // If mouse is over container
  {
    var mouseX = Math.floor((mouse.x - this.x - 2) / 32); // Get tile co-ords
    var mouseY = Math.floor((mouse.y - this.y - 2) / 32); // Get tile co-ords
  }
  for (var y = 0; y < 6; y++)
  {
    for (var x = 0; x < 6; x++)
    {
      // Draw tiles
      if(tileset[tilesetSelection].tile[(this.vScroll * 6) + (y * 6) + x]) tileset[tilesetSelection].tile[(this.vScroll * 6) + (y * 6) + x].blit(this.x + 2 + (x * 32), this.y + 2 + (y * 32));
      // If tile selected draw highlight
      if ((this.vScroll * 6) + (y * 6) + x == tileSelection) 
      {
        Rectangle(this.x + 2 + (x * 32), this.y + 2 + (y * 32), 32, 32, CreateColor(255, 0, 255, 100));
        tile32.blit(this.x + 2 + (x * 32), this.y + 2 + (y * 32));
      }
      // If mouse is over draw highlight
      if (x == mouseX && mouseY == y) tile32.blit(this.x + 2 + (x * 32), this.y + 2 + (y * 32));
    }
  }
  this.scrollBar.render(); // Draw Scrollbar
}



function _button(parent, x, y, image, image2)
{
  this.name = "Button";
  this.parent = parent;
  this.x = this.parent.x + x;
  this.y = this.parent.y + y;
  this.w = image.width;
  this.h = image.height;
  this.superParent = getParent(this);
  this.image = image;
  this.pressImage = image2 || image;
  this.w = image.width;
  this.h = image.height
  this.mouseIsOver = function() {}; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  this.leftOnPress = function () {};
  this.leftOnHeld = function () {};
  this.leftOnRelease = function () {};
  this.rightOnPress = function () {};
  this.rightOnHeld = function () {};
  this.rightOnRelease = function () {};
  this.middleOnPress = function () {};
  this.middleOnHeld = function () {};
  this.middleOnRelease = function () {};
  this.wheelScrollUp = function ()
  {
    if (this.parent instanceof verticalScrollBar && this.parent.wheelScrollDown)
    {
      this.parent.wheelScrollUp();
    }
  }
  this.wheelScrollDown = function ()
  {
    if (this.parent instanceof verticalScrollBar && this.parent.wheelScrollDown)
    {
      this.parent.wheelScrollDown();
    }
  }
  this.addProperty = function (name, arg) { this[name] = arg; };
}

_button.prototype.handleMouse = function()
{
  mouse.isMouseOver(this.x, this.y, this.w, this.h, this);
}

_button.prototype.render = function()
{
  this.image.blit(this.x, this.y);
}

//========================================================================================================================
//                                                     Vertical ScrollBar
//========================================================================================================================
function verticalScrollBar(parent, offset)
{
  this.name = "Vertical Scroll Bar";
  
  this.grabbed = false;
  this.parent = parent;
  this.x = this.parent.x + 2 + this.parent.w - 16;
  this.y = this.parent.y + 2
  this.w = 16;
  this.h = this.parent.h;
  if (offset) this.h -= 16;
  this.timer = GetTime();
  this.lastScroll = 0;
  
  this.leftOnPress = function()
  {
    //this.timer = GetTime() + 200;
    //var position = Math.floor((mouse.y - (this.y + 18)) / this.middleButton.h); // Work out current position within bar, in relation to the mouse
    //if (position > this.parent.vMax) position = this.parent.vMax;
    //if (position < 0) position = 0;
    //
    //if (position < this.parent.vScroll) 
    //{
    //  this.lastScroll = 0;
    //  this.parent.vScroll--;
    //}
    //
    //if (position > this.parent.vScroll)
    //{
    //  this.lastScroll = 1;
    //  this.parent.vScroll++;
    //}
    //return this.updateMiddle();
    Abort("Not Yet!!");
  }
    
  this.leftOnHeld = function ()
  {
    if (GetTime() > this.timer + 100)
    {
      this.timer = GetTime();
      var position = Math.floor((mouse.y - (this.y + 18)) / this.middleButton.h); // Work out current position within bar, in relation to the mouse
      if (position > this.parent.vMax) position = this.parent.vMax;
      if (position < 0) position = 0;
      
      if (position > this.parent.vScroll && this.lastScroll)
      {
        this.parent.vScroll++;
      }
      if (position < this.parent.vScroll && !this.lastScroll) 
      {
        this.parent.vScroll--;
      }
    }
    return this.updateMiddle();
  }
  
  this.wheelScrollUp = function()
  {
    if (this.parent.vScroll - 1 >= 0)
    {
      this.parent.vScroll--;
      this.middleButton.y = this.y + 16 + (this.middleButton.h * this.parent.vScroll);
    }
  }
  
  this.wheelScrollDown = function()
  {
    if (this.parent.vScroll + 1 <= this.parent.vMax)
    {
      this.parent.vScroll++;
      this.middleButton.y = this.y + 16 + (this.middleButton.h * this.parent.vScroll);
    }
  }
  
  this.superParent = getParent(this);
  var height = Math.floor((this.h - 32) / (this.parent.vMax + 1))
  if (height < 1) height = this.h - 32;
  
  var image = CreateSurface(16, height, CreateColor(195, 195, 195, 255));
  image.line(image.width - 1, 0, image.width - 1, image.height - 1, CreateColor(0, 0, 0, 255));
  image.line(0, image.height - 1, image.width - 1, image.height - 1, CreateColor(0, 0, 0, 255));
  
  image.line(1, 1, image.width - 2, 1, CreateColor(255, 255, 255, 255));
  image.line(1, 1, 1, image.height - 2, CreateColor(255, 255, 255, 255));
      
  image.line(image.width - 2, 1, image.width - 2, image.height - 2, CreateColor(122, 132, 131, 255));
  image.line(2, image.height - 2, image.width - 2, image.height - 2, CreateColor(122, 132, 131, 255));
  
  image.createImage();
  
  this.scrollUp = new _button(this, 0, 0, scrollUp);
  this.scrollUp.name = "Scroll Up";
  this.scrollUp.leftOnPress = function()
  {
    if (this.parent.parent.vScroll - 1 >= 0)
    {
      this.parent.parent.vScroll--;
      this.parent.updateMiddle();
    }
  }
  
  this.middleButton = new _button(this, 0, 16, image);
  this.middleButton.name = "Middle Button";
  this.middleButton.leftOnHeld = function()
  {
    //var position = Math.floor((mouse.y - (this.parent.y + 18)) / this.h); // Work out current position within bar, in relation to the mouse
    //if (position > this.parent.parent.vMax) position = this.parent.parent.vMax;
    //if (position < 0) position = 0;
    //if (position <= this.parent.parent.vMax && position >= 0) // If within the confines of the bar
    //{
    //  this.parent.parent.vScroll = position; // Se new position based on earlier calculation
    //  this.y = this.parent.y + 16 + (this.h * position);
    //}
    Abort("Not Yet!!");
  }
  this.scrollDown = new _button(this, 0, this.h - 16, scrollDown);
  this.scrollDown.name = "Scroll Down";
  this.scrollDown.leftOnPress = function()
  {
    if (this.parent.parent.vScroll + 1 <= this.parent.parent.vMax)
    {
      this.parent.parent.vScroll++;
      this.parent.updateMiddle();
    }
  }
  this.updateMiddle = function()
  {
    this.middleButton.y = this.y + 16 + (((this.h - 32 - this.middleButton.h) / this.parent.vMax) * this.parent.vScroll);
    //Abort(this.middleButton.y)
  }
}
//========================================================================================================================
//                                                    Vertical Scrollbar - Handle Mouse
//========================================================================================================================
verticalScrollBar.prototype.handleMouse = function()
{
  mouse.isMouseOver(this.x, this.y + 16, 16, this.h - 32, this);
  this.scrollUp.handleMouse();
  this.middleButton.handleMouse();
  this.scrollDown.handleMouse();
}

//========================================================================================================================
//                                                     Vertical Scrollbar - Handle Button
//========================================================================================================================
verticalScrollBar.prototype.handleButton = function(integ)
{
  // Handle the button controls
  switch (integ)
  {
    case 0:
    {
      // Handle Up button
      if (this.parent.vScroll > 0) this.parent.vScroll--; // Scroll Up
      break;
    }
    case 1:
    {
      // Handle Down button
      if (this.parent.vScroll < this.parent.vMax) this.parent.vScroll++; // Scroll Down
      break;
    }
  }
}

//========================================================================================================================
//                                                     Vertial ScrollBar - Render
//========================================================================================================================
verticalScrollBar.prototype.render = function()
{
  Rectangle(this.parent.x + this.parent.w - 14, this.y, 16, this.h, windowGrey3); // Scrollbar background - MAY BE BETTER AS IMAGE
  this.scrollUp.render();
  this.middleButton.render();
  this.scrollDown.render();
}

//========================================================================================================================
//                                                     Horizontal ScrollBar
//========================================================================================================================
function horizontalScrollBar(parent, offset)
{
  this.name = "Horizontal Scroll Bar";
  
  this.grabbed = false;
  this.parent = parent;
  this.x = this.parent.x + 2;
  this.y = this.parent.y + 2 + this.parent.h - 16
  this.w = this.parent.w;
  this.h = 16;
  if (offset) this.w -= 16;
  this.timer = GetTime();
  //this.lastScroll = 0;
  
  this.leftOnPress = function()
  {
  //  this.timer = GetTime() + 200;
  //  var position = Math.floor((mouse.y - (this.y + 18)) / this.middleButton.h); // Work out current position within bar, in relation to the mouse
  //  if (position > this.parent.vMax) position = this.parent.vMax;
  //  if (position < 0) position = 0;
  //  
  //  if (position < this.parent.vScroll) 
  //  {
  //    this.lastScroll = 0;
  //    this.parent.vScroll--;
  //  }
  //  
  //  if (position > this.parent.vScroll)
  //  {
  //    this.lastScroll = 1;
  ///    this.parent.vScroll++;
  //  }
  //  return this.updateMiddle();
  Abort("Not Yet!");
  }
    
  this.leftOnHeld = function ()
  {
  //  if (GetTime() > this.timer + 100)
  //  {
  //    this.timer = GetTime();
  //    var position = Math.floor((mouse.y - (this.y + 18)) / this.middleButton.h); // Work out current position within bar, in relation to the mouse
  //    if (position > this.parent.vMax) position = this.parent.vMax;
  //    if (position < 0) position = 0;
  //    
  //    if (position > this.parent.vScroll && this.lastScroll)
  //    {
  //      this.parent.vScroll++;
  //    }
  //    if (position < this.parent.vScroll && !this.lastScroll) 
  //    {
  //      this.parent.vScroll--;
  //    }
  //  }
  //  return this.updateMiddle();
  Abort("Not Yet!!");
  }
  
  this.superParent = getParent(this);
  var width = Math.floor((this.w - 32) / (this.parent.hMax + 1))
  if (width < 1) width = this.w - 32;
  
  var image = CreateSurface(width, 16, CreateColor(195, 195, 195, 255));
  image.line(image.width - 1, 0, image.width - 1, image.height - 1, CreateColor(0, 0, 0, 255));
  image.line(0, image.height - 1, image.width - 1, image.height - 1, CreateColor(0, 0, 0, 255));
  
  image.line(1, 1, image.width - 2, 1, CreateColor(255, 255, 255, 255));
  image.line(1, 1, 1, image.height - 2, CreateColor(255, 255, 255, 255));
      
  image.line(image.width - 2, 1, image.width - 2, image.height - 2, CreateColor(122, 132, 131, 255));
  image.line(2, image.height - 2, image.width - 2, image.height - 2, CreateColor(122, 132, 131, 255));
  
  image.createImage();
  
  this.scrollLeft = new _button(this, 0, 0, scrollLeft);
  this.scrollLeft.name = "Scroll Up";
  this.scrollLeft.leftOnPress = function()
  {
    if (this.parent.parent.hScroll - 1 >= 0)
    {
      this.parent.parent.hScroll--;
      this.parent.updateMiddle();
    }
  }
  
  this.middleButton = new _button(this, 16, 0, image);
  this.middleButton.name = "Middle Button";
  this.middleButton.leftOnHeld = function()
  {
    //var position = Math.floor((mouse.y - (this.parent.y + 18)) / this.h); // Work out current position within bar, in relation to the mouse
    //if (position > this.parent.parent.vMax) position = this.parent.parent.vMax;
    //if (position < 0) position = 0;
    //if (position <= this.parent.parent.vMax && position >= 0) // If within the confines of the bar
    //{
    //  this.parent.parent.vScroll = position; // Se new position based on earlier calculation
    //  this.y = this.parent.y + 16 + (this.h * position);
    //}
    Abort("Not Yet!!");
  }
  this.scrollRight = new _button(this, this.w - 16, 0, scrollRight);
  this.scrollRight.name = "Scroll Right";
  this.scrollRight.leftOnPress = function()
  {
    if (this.parent.parent.hScroll + 1 <= this.parent.parent.hMax)
    {
      this.parent.parent.hScroll++;
      this.parent.updateMiddle();
    }
  }
  this.updateMiddle = function()
  {
    this.middleButton.x = this.x + 16 + (((this.w - 32 - this.middleButton.w) / this.parent.hMax) * this.parent.hScroll);
  }
}
//========================================================================================================================
//                                                    Vertical Scrollbar - Handle Mouse
//========================================================================================================================
horizontalScrollBar.prototype.handleMouse = function()
{
  mouse.isMouseOver(this.x + 16, this.y, this.w - 32, 16, this);
  this.scrollLeft.handleMouse();
  this.middleButton.handleMouse();
  this.scrollRight.handleMouse();
}

//========================================================================================================================
//                                                     Vertical Scrollbar - Handle Button
//========================================================================================================================++++++++++++++++++++++++++++++++++++++++++++
horizontalScrollBar.prototype.handleButton = function(integ)
{
  // Handle the button controls
  switch (integ)
  {
    case 0:
    {
      // Handle Up button
      if (this.parent.hScroll > 0) this.parent.hScroll--; // Scroll Up
      break;
    }
    case 1:
    {
      // Handle Down button
      if (this.parent.hScroll < this.parent.hMax) this.parent.hScroll++; // Scroll Down
      break;
    }
  }
}

//========================================================================================================================
//                                                     Vertial ScrollBar - Render
//========================================================================================================================
horizontalScrollBar.prototype.render = function()
{
  Rectangle(this.x, this.y, this.w, 16, windowGrey3); // Scrollbar background - MAY BE BETTER AS IMAGE
  this.scrollLeft.render();
  this.middleButton.render();
  this.scrollRight.render();
}



//========================================================================================================================
//                                                     Game Functions
//========================================================================================================================

var tilePanel = new _tilePanel(); // Create the tile panel
var mapPanel = new _mapPanel();

var frameRate = 60; // Set the frame rate

function _frameEngine()
{
  this.CPS = 0;
  this.FPS = 0;
  this.CPSTimer = GetTime();
  this.FPSTimer = GetTime();
  this.currentCPS = 0;
  this.currentFPS = 0;
  this.frame = 0;
  this.time = GetTime();
  
  this.update = function() {};
  this.render = function() {};

  this.execute = function()
  {
    while (!IsKeyPressed(KEY_ESCAPE))
    {
      this.update();
      this.time = GetTime();
      if (this.time > this.CPSTimer + 1000)
      {
        this.currentCPS = this.CPS + 1;
        this.currentFPS = this.FPS + 1;
        this.CPS = 0;
        this.FPS = 0;
        this.CPSTimer = this.time;
        this.FPSTimer = this.time;
      }
      else
      {  
        this.CPS++;
        if (this.time > this.FPSTimer + (1000 / frameRate))
        {
          this.FPS++;
          this.FPSTimer += (1000 / frameRate);
        }
      }
      if (this.frame != this.FPS)
      {
        //Rectangle(0, 0, 800, 600, red);
        this.render();
        this.frame = this.FPS;
        drawText(0, 45, this.FPS);
        drawText(0, 15, this.currentCPS);
        drawText(0, 30, this.currentFPS);
        FlipScreen();
      }
    }
  }
}


var frameEngine = new _frameEngine();
frameEngine.update = function()
{
  
}
frameEngine.render = function()
{
  tilePanel.render();
  mapPanel.render();
  mouse.update();
  mouse.render();
}
frameEngine.execute();































function game2()
{
  var temp = createWindow(200, 200, 0, 0);
  while (temp)
  {
    mouse.update();
    tilePanel.render();
    mouse.draw();
    FlipScreen()
  }
}